/*
	GWAP - A good Web Audio Player 
	
	by Joseph Beeson -- email : joseph beeson at 'g' mail daught com
	
	This script allows for persistent, embeddable playlists on your website. Built using Niftyplayer and jQuery
	
	Version 1.0.21
		player width variable, starts slim and expands when first song played
	
	Version 1.0.20
		default playlist file now in conf file
		delay added to playlist open/close animation to avoid crazy open/close flickering
		
	Version 1.0.19
		default playlist now fetched via ajax
		
	Version 1.0.18
		Fixed bug in Firefox: when the playlist is empty, when a user clicks a song it loads but does not start to play

	Version 1.0.17
		Redid interface, now only the playlist part moves on mouseover
		Fixed numerous bugs - IE7 now solid
		New feature : when user clicks previous and next buttons, the playlist autoscrolls to the activated song.
	
	Version 1.0.16
		Oh let me count the many ways of saying "oh how I hate you IE"
	
	Version 1.0.15
		Better subdomain handling
		Reorganised file structure for better version management
	
	Version 1.0.14
		Forms now captured.  Forms submitted to out of scope URLs now opened in new browser tab.
		
	Version 1.0.13
		switched to using escape/unescape functions instead of base64 and LZW for better URL readability
		
	Version 1.0.12
		added appendTo beginning/end feature in configuration
		fixed varius issues
		
	version 1.0.11
		moved GetElementsByClass to DOMshortcuts to avoid namespace conflicts
		added jQuery.noConflict() to avoid mootools conflicts
	
	Version 1.0.10
		new feature stripWWW to remove the www subdomain, fixes a bug where external links with www can cause the user to be redirected to the main page rather than the page requested.
	
	Version 1.0.9
		IE6 fails gracefully
		JS now saved in UTF8 encoding
	
	Version 1.0.8
		fixed CSS glitches
		updated getplIUDClass() to be more consistent
		found whacky bug -- if the first line of iFrame_default.txt is our id, it gets ignored by gwap.jss .... no clue why.  Fix: card coded iframe.php to make id of default playlist be 'default'
	
	Version 1.0.7
		code cleanup
		ditched php-generated args introduced in 1.0.4, now pure javascript config
		new config file gwap_conf.js
		New DOMshortcuts version
		jquery 1.4.1
	
	Version 1.0.6
		playerbox now springs open and closed on hover, rather than fading in and out
		playerbox springs open on playlist append
		hitting spacebar toggles playback (not working in IE)
		
	Version 1.0.5
		stylesheets used for hover/unhover events for the player
		iforceFrame.js and gwap.js now consolidated in single file
		redirect now triggered on page load, user does not see page flicker beforehand
		
	Version 1.0.4
		forceiFrame can now be defined in the <script> tag			
						
*/ 


var gwap = {
	firstplay				: 1,
	nowPlaying			: 0,
	n							: 0,
	textInputFocus		: 0,
	playervisible		: 0,
	playlistHoverState : 0, //1 = mouseover, 0 = mouseout
	godDamnIE	:	0,
	hash : parent.location.hash,

	next : function (obj){
		var n = parent.gwap.nowPlaying.parentNode.nextSibling;
		if(obj) {
			n = obj;
		}
		if(n) {
			if(n.tagName == "SPAN") {
				gwap.skipTo(n.firstChild, 3);
			} else {
				// next obj is a title, skip to next obj
				if(n.nextSibling){
					gwap.next(n.nextSibling)
				} else {
					gwap.skipToFirst();
					gwap.playToggle();			
				}
			}
		}

	},
	
	prev : function(obj){
		var n = parent.gwap.nowPlaying.parentNode.previousSibling;
		if(obj) {
			n = obj;
		}
		//alert(n.tagName);
		if(n.tagName == "SPAN"){
			gwap.skipTo(n.firstChild, 3);
		} else if (n.previousSibling){
			// prev obj is a title, skip to prev obj again
			gwap.prev(n.previousSibling);
		} else {
			var pl = d.ge("gwapPlaylist");
			var lis = pl.getElementsByTagName('span');
			gwap.prev(lis[lis.length-1]);
		}

	},
	
	playToggle : function() {
		if(parent.gwap.nowPlaying == 0) {
			gwap.skipToFirst();
			gwap.n.play();	
		} else {
			var i = parent.frames['mainIFrame'].document;
			var s = gwap.n.getPlayingState();
			if(s == "playing") {
				gwap.n.pause();
			} else {
				gwap.n.play();

			}
		}
		gwap.n = parent.niftyplayer("gwapPlayer");
		gwap.setPlayIcon();

	},
		
	setPlayIcon : function() {
		gwap.n = parent.niftyplayer("gwapPlayer");
		var i = parent.frames['mainIFrame'].document;
		var s = gwap.n.getPlayingState();
		if(parent.gwap.nowPlaying == 0){
			return false;
		}
		try{
			var newId = parent.gwap.nowPlaying.parentNode.id;
			
			if(s == "playing") {
				jQuery("#gwapplayToggle").css("background-image", "url(gwap/img/bigplay.png)");
				jQuery(d.ge(newId).firstChild).attr('id', "gwapNowPlaying").attr('class','');
				try{
					jQuery(i.getElementById(newId).firstChild).attr('class', "").attr( 'id', "gwapNowPlaying");
				} catch(err) {};
			
			} else {
				jQuery("#gwapplayToggle").css("background-image", "url(gwap/img/bigpause.png)");
				jQuery(d.ge(newId).firstChild).attr('id', "gwapNowPaused").attr('class', "");
				try{
					jQuery(i.getElementById(newId).firstChild).attr('id', "gwapNowPaused").attr( 'class', "");
				} catch(err) {};
			}
		}catch(err){}
	},
	
	skipTo : function(newObj, play){
		if(gwap.playervisible == 0) {
			gwap_conf.playerBoxSlideIn(10);
		}
		var firstSong = 1;
		gwap.n = parent.niftyplayer("gwapPlayer");
		

		
		var i = parent.frames['mainIFrame'].document;
		
		// this can be called from the child or parent, append playlist to parent list if it doesn't already exist
		var newId = newObj.parentNode.id;
		//alert(newId);
		var plUIDClass = "gwapPlaylistId_"+newId.split('_')[1];
		var alreadyExists = 0;
		try{
			alreadyExists = d.ge(plUIDClass).id;
		}catch(err){ }

		
		if(alreadyExists == 0) {
			// append the new songs
			var pl = d.ge("gwapPlaylist");		
			if(gwap.godDamnIE == 1) {
				pl.innerHTML += newObj.parentNode.parentNode.innerHTML; //ok this method is just retarded, but so is IE7
			} else if( gwap_conf.appendTo == 'beginning'){
				jQuery(newObj.parentNode.parentNode.childNodes).clone().prependTo(pl);	
			} else {
				jQuery(newObj.parentNode.parentNode.childNodes).clone().appendTo(pl);	
			}


			/*
			// pop the playerbox open
			if(gwap_conf.playerActionOnAppend == 'bounce') {
				gwap_conf.playerBoxBounce();
			} else {
				gwap_conf.playerBoxOpen();
				window.setTimeout('gwap_conf.playerBoxClose()', 900);
			}
			*/
			//gwap.playBoxOpenOnAppend = 1;
			
			//redefine the onclick event handlers for the delete button
			jQuery(".gwapdelPlaylist").click(function(){
				gwap.delPlaylist(this.parentNode.parentNode.className)
			});
			
			//redefine the onclick event handlers for the infolinks
			jQuery(".infoLink").click(function(){
				alert(this.href);
				//window.parent.frames['mainIFrame'].document.location.replace(this.href);
				return false;
			});
			
			// redefine the onclick event handlers for the playlist items
			jQuery('.'+plUIDClass+' a').click(function(){
				gwap.skipTo(this, 2); return false;
			});
					
		}
		
		newObj.blur();
		// redefine newObj to always refer to object in parent list, not child list
		newObj = parent.document.getElementById(newId).firstChild;
		if(play == 2 & (newObj == parent.gwap.nowPlaying)){
			// play = 2 means this event was triggered by the user
			gwap.playToggle();
			return;
		}
		
		var path = newObj.href;
		parent.gwap.nowPlaying = newObj;
		if(play == -1) {
			gwap.n.load(path);
		} else {
			//do the rest of this function 100ms later in parallel to avoid a bug in FF3.6
			window.setTimeout(function(){
			
				gwap.n.loadAndPlay(path);
				//remove play icon from previous song in parent and child
				jQuery('#mainIFrame').contents().find('#gwapNowPaused, #gwapNowPlaying').addClass('gwapHasPlayed').removeAttr('id');
				jQuery('#gwapNowPaused, #gwapNowPlaying').addClass('gwapHasPlayed').removeAttr('id');

				//set play icon to new song in parent and child
				gwap.setPlayIcon();
				d.ge("CurrentSongName").innerHTML = newObj.innerHTML;
				gwap.n.registerEvent("onSongOver", "gwap.next()");
				if(play == 3) { // 3 == prev or next btn was clicked
					try{
						jQuery('#gwapPlaylist').scrollTo('a#gwapNowPlaying', 100);
					}catch(err){}
				}
				// resize gwap player to specifed width if this is the first song added
				if(jQuery('#gwapPlayerDiv').width() == gwap_conf.playerInitWidth) {
					jQuery('#gwapPlayerDiv').css(
						'width' , gwap_conf.playerWidth+"px"
					)
					jQuery('#gwapPlaylistContainer').css(
						'width' , gwap_conf.playlistWidth+"px"
					);
					jQuery('#CurrentSongName').animate({
						width : "+=160"		
					});
				}

			}, 100);
		}


	},
	
	skipToFirst : function() {
		//means this is the first playlist appended, queue first song
		var pl = d.ge("gwapPlaylist");
		var lis = pl.getElementsByTagName('span');
		gwap.skipTo(lis[0].firstChild, -1);
	},
	
	delPlaylist : function(classUID) {
		var i = parent.frames['mainIFrame'].document;

		jQuery("."+classUID).fadeOut(400, function(){
			jQuery("."+classUID).remove();
		});
		if(parent.gwap.nowPlaying != 0) {
			var a = parent.gwap.nowPlaying.parentNode;
			if(a.className == classUID){
				gwap.n.stop();
				gwap.nowPlaying = 0;
				d.ge("CurrentSongName").textContent = "";
				jQuery('#mainIFrame').contents().find('.gwapNowPaused').addClass('gwapHasPlayed');
				jQuery('.gwapNowPaused').addClass('gwapHasPlayed');
				jQuery('#mainIFrame').contents().find('#gwapNowPlaying').addClass('gwapHasPlayed');
				jQuery('#gwapNowPlaying').addClass('gwapHasPlayed');
				jQuery('#mainIFrame').contents().find('#gwapNowPlaying').removeClass('gwapNowPlaying');
				jQuery('#mainIFrame').contents().find('.gwapNowPaused').removeClass('gwapNowPaused');
				jQuery('#gwapNowPlaying').removeClass('gwapNowPlaying');
				jQuery('.gwapNowPaused').removeClass('gwapNowPaused');
			}
		}
		

	},
	
	appendArray2DOMObj : function(appendArray) {
		//converts the appendArray object to a DOM object, returns a flat array containing the objects
		var reserved = {
			'title':1,
			'showTitle':1,
			'id':1,
			'playOnAppend':1,
			'delBtn':1
		};
		var out = new Array;
		var track = 1;
		var title = d.ce("div");
		var plId = "gwapList";
		var delBtn = d.ce("div");
		d.sa(delBtn, "class", "gwapdelPlaylist");
		jQuery(delBtn).click(function(){
			gwap.delPlaylist(this.parentNode.parentNode.className)
		});

		var t = appendArray["title"];
		if(t === undefined) {
			t = 'Untitled Playlist';
			appendArray["title"] = t;
			appendArray["showTitle"] = false;
		}
		var plIUDClass = gwap.getplIUDClass(appendArray);
		d.sa(title, "id", plIUDClass);
		d.sa(title, "class", plIUDClass);
		
		if(appendArray["showTitle"] == 0 || appendArray["showTitle"] == false || !t) {
			title.style.display = "none";
		}
		
		var titleDiv = d.ce("div");
		d.sa(titleDiv, "class", "gwapListTitle");					
		if(appendArray["delBtn"] != 0 && !gwap.godDamnIE) {
			d.ac(titleDiv, delBtn);
			d.ac(delBtn,d.ct('x'));
			delBtn.onclick = function(){gwap.delPlaylist(this.parentNode.parentNode.className)};
		}
		
		d.ac(titleDiv,d.ct(t));
		
		//add titlediv to li
		d.ac(title, titleDiv);
		out.push(title);
		
		for(var t in appendArray){
			var s = ""+appendArray[t];
			if(!reserved[t]) {
				//create link
				var a = d.ce("a");
				d.sa(a, "href", s);
				a.onclick = function(){
					parent.gwap.skipTo(this,2); return false;
				};
				d.ac(a,d.ct(t));

				// create li
				var li = d.ce("span");
				d.sa(li, 'class', plIUDClass);
				d.sa(li, 'id', plIUDClass+'_'+track);
				track++;
				//append link to li
				d.ac(li,a);
				
				//append li to out
				out.push(li);
			}
		}
		return out;
	},
	
	getplIUDClass : function (appendArray) {
		var re = new RegExp("[ \.]", 'g');
		var id = appendArray["id"];
		if(id === undefined) {
			id =  Math.floor(Math.random()*10000);
			appendArray["id"] = id;
		}
		
		var t = 'gwapPlaylistId'+'_'+appendArray["id"];
		return t.replace(re, '');
	},
	
	cleanAppendArray : function(appendArray) {
		var out = new Object();
		for(var k in appendArray) {
			var v2 = appendArray[k].replace(/^\s+/g,'').replace(/\s+$/g,'');
			var k2 = k.replace(/^\s+/g,'').replace(/\s+$/g,'');
			out[k2] = v2;
		}
		return out;	
	},
	
	printChildList : function(appendArray, myid) {
		var i = parent.frames['mainIFrame'].document;
		var appendArray2 = gwap.cleanAppendArray(appendArray);
		var newObj = gwap.appendArray2DOMObj(appendArray2);
		try {
			var target = i.getElementById(myid);
			var title = newObj.shift();
			d.ac(target, title);
			for(var a in newObj) {
				var li = newObj[a];
				d.ac(target, li);
			};
			target.className = 'gwapPlaylist';
			
			// if the playlist was loaded but is already playing in parent, set its icon to play		
		} catch(err){}
		gwap.setPlayIcon();
		
	},
	
	appendToParentList : function(appendArray) {
		var plIUDClass = gwap.getplIUDClass(appendArray);
		var checkDupe = d.ge(plIUDClass);
		try{
			if(checkDupe.id) {
				return;
			};
		} catch(err){}
		var newObj = gwap.appendArray2DOMObj(appendArray);
		var pl = d.ge("gwapPlaylist");
	
		d.ac(pl, newObj.shift());
		for(var a in newObj) {
			var li = newObj[a];			
			d.ac(pl, li);
		}

	},
	
	getSpacebar: function(keyCode){
		//alert('getSpacebar');
		if(keyCode == 32 & gwap.textInputFocus == 0) {
			gwap.playToggle();
			return false;
		}
	},
   
	IEgetSpacebar: function(){
		//alert('getSpacebar');
		gwap.getSpacebar(event.keyCode);
	},
	
	
	/* ============ this part of gwap forces the website into an iframe ========== */

	
	updateTitleFavicon : function() {
		// as name implies, sends child doc title and favicon to parent
		parent.document.title = document.title;
		var a = document.getElementsByTagName('link');
		try{
			jQuery('.parentfavicon', parent.document).remove();
		} catch(err){}
		
		for(var b in a) {
			var t = a[b].type;
			if(t == 'image/x-icon') {
				var link = parent.document.createElement('link');
				link.type = 'image/x-icon';
				link.rel = 'shortcut icon';
				link.className = 'parentfavicon';
				link.href = a[b].href;
				parent.document.getElementsByTagName('head')[0].appendChild(link);
			}
		}
	},

	updateChildURL : function() {
		var myurl = location.hash;
		if(myurl == "") {
			myurl = gwap_conf.scope+gwap_conf.defaultPage;
		} else {
			myurl = gwap.decodeUrl(myurl);
		}
		
		window.parent.frames['mainIFrame'].document.location.replace(myurl);
		
	},

	captureIframeLinks : function() {
		//alert('captureIframeLinks');
		var links = document.getElementsByTagName('a');
		for(i = 0; i < links.length; i++) {
			if(links[i].onclick){
				continue; //don't clobber existing onclicks
			}
			if(links[i].target == "") {
				links[i].onclick = function(){parent.gwap.updateParentURL(this.href); return false;}
			}
		}
		var forms = document.getElementsByTagName('form');
		for(i = 0; i < forms.length; i++) {
			if(!gwap.checkIfInScope(forms[i].action)) {
				d.sa(forms[i], 'target', '_new');
			}
		}

	},
	
	pollHash : function () {
	// shitty hack to update child iframe when back / forward buttons are pressed
		if(gwap.hash != location.hash) {
			gwap.hash = location.hash;
			gwap.updateChildURL();
		}
	},

	updateParentURL : function(childUrl) {
		//alert('updateParentURL');
		var res = gwap.checkIfInScope(childUrl);
		if(res){
			//alert('in scope');
			var encurl = gwap.encodeUrl(res);
			var url = ""+window.location;
			var baseurl = url.split('#', 1);
			window.location = baseurl + '#' + encurl;
		 } else {
			//alert('out of scope');
			window.location = childUrl;
		}

	},
	
	checkIfInScope : function(url) {
		if(url == gwap_conf.scope) {
			return true;
		}
		var ScopeRe = new RegExp('^'+gwap_conf.scope);
		var m = url.match(ScopeRe);
		if(m == null) {
			//not in domain
			return false;
		}
		//in domain, return relative path
		return url.substr(gwap_conf.scope.length);

	},
	
	encodeUrl : function(s) {
		if(s.length > 0){
			return escape(s);
		} else {
			return '';
		}
	},
	
	decodeUrl : function(s){
		var u = unescape(s);
		return u.substr(1);
	},
	
	ParentWindowResize : function(){
		var i = d.ge('mainIFrame');
		var h = document.documentElement.clientHeight || document.body.clientHeight;
		i.style.height = h + "px";
	}
	
}
	var subdomain = window.location.hostname.split('.');
	//alert(subdomain[0]);
// www subdomain handling
if(gwap_conf.WWWsubdomain) {

	if(gwap_conf.WWWsubdomain == 'strip') {
	
	if(www == 'www.'){
		// remove the friggin www
		var remLen = window.location.protocol+"//www.";
		var newurl = window.location.protocol+"//"+window.location.href.substring(remLen.length);
		window.location.replace(newurl);
		gwap_conf.me = '0';
	}
	} //else if (gwap_conf.WWWsubdomain == 'force') {

}

// IE-specific junk
if (/MSIE (\d+\.\d+);/.test(navigator.userAgent)){
	var ieversion=new Number(RegExp.$1);
	if(ieversion < 7) {
		// No IE6, sorry tards
		gwap_conf.me = 'ie6';
		if(gwap.hash.length > 0) {
			window.location = gwap.decodeUrl(gwap.hash)
		}
		gwap.printChildList = function(appendArray, myid) {
			var appendArray2 = gwap.cleanAppendArray(appendArray);
			var newObj = gwap.appendArray2DOMObj(appendArray2);

				var target = d.ge(myid);
				var title = newObj.shift();
				//d.ac(target, title);
				for(var a in newObj) {
					try {
					var li = newObj[a];
					li.onclick = function(){alert(gwap_conf.IE6failMsg)};
					d.ac(target, li);
					} catch(err){}
				};
				target.className = 'gwapPlaylist';
		}
		
	}
	gwap.godDamnIE = 1;

	// Suppress all IE errors
	function STFUie() {return true;}
	window.onerror=STFUie;
}

if(gwap_conf.me == 'child') {
	// Embed the page as a child iFrame in the defined parent document
	var id = 0;
	try {
		id = window.frameElement.id;
	} catch(err) { }
	if(id == 0){
		// we're not in an frame, embed self in iframe
		var myurl = ""+document.location;
		var relurl = gwap.checkIfInScope(myurl);
		var urlenc = gwap.encodeUrl(relurl);
		if(urlenc.length > 0) {
			urlenc = '#'+urlenc;
		}
		var dest = gwap_conf.scope+gwap_conf.iFrameFile+urlenc;
		window.location = dest;
	};

	jQuery(document).ready(function(){
		gwap.updateTitleFavicon();
		gwap.captureIframeLinks();
		try{
			gwap.n = parent.niftyplayer("gwapPlayer");
		}catch(err){}
		// set up the event handlers for the spacebar
		document.onkeydown=function(event){return parent.gwap.getSpacebar(event.keyCode)};
		var inputs = document.getElementsByTagName('input');
		var newOnf = function(){parent.gwap.textInputFocus = 1; return true;};
		var newObl = function(){parent.gwap.textInputFocus = 0; return true;};
		for(var i in inputs) {
			if(inputs[i].type == 'text'){
				inputs[i].addEventListener('focus', newOnf, false);
				inputs[i].addEventListener('blur', newObl, false);
			}
		}
		var inputs = document.getElementsByTagName('textarea');
		for(var i in inputs) {		
			try{
				inputs[i].addEventListener('focus', newOnf, false);
				inputs[i].addEventListener('blur', newObl, false);
			}catch(err){}
		}
	});
}

if(gwap_conf.me == 'parent') {
	jQuery(document).ready(function() {
		try{ // Safari 4 Mac likes having this little try catch bit just for shits
			gwap.n = parent.niftyplayer("gwapPlayer");
		}catch(err){}
		
		gwap.ParentWindowResize();
		
		gwap_conf.closedbottom = d.ge('playerbox').offsetHeight;

		if(gwap_conf.playerVisibleByDefault == 1) {
			window.setTimeout("gwap_conf.playerBoxSlideIn();", gwap_conf.slideinDelay);
		}
		
		gwap.updateChildURL();
		setInterval(gwap.pollHash, 400);

		document.onkeydown=function(event){return gwap.getSpacebar(event.keyCode)}; // key catcher for everyone else
		
		jQuery("#gwapplayToggle").click(function(){
			gwap.playToggle();
		});

		jQuery("#gwapplaynext").click(function(){
			gwap.next();
		});
		jQuery("#gwapplayprev").click(function(){
			gwap.prev();
		});
		
		jQuery("#CurrentSongName").css(
			"width", "0px"
		);
		jQuery("#gwapPlayerDiv").css(
			"width", gwap_conf.playerInitWidth+"px"
		);
		
		//jQuery('#'+gwap_conf.playerBoxID).hover(function(){
		jQuery('#gwaphoverzone').hover(function(){
			//mouseIn
			gwap.playlistHoverState = 1;
			window.setTimeout(function(){
				if(gwap.playlistHoverState == 1){
					jQuery('#gwapPlaylistContainer').stop(true, true);			
					gwap_conf.playerBoxOpen();
					gwap.playlistHoverState = 1;
				}
			}, 20);
		},function(){
			//mouseOut
			gwap.playlistHoverState = 0;
			window.setTimeout(function(){
				if(gwap.playlistHoverState == 0){
					jQuery('#gwapPlaylistContainer').stop(true, true);			
					gwap_conf.playerBoxClose();
					gwap.playlistHoverState = 0;
				}
			}, 150);
		});
			
	});

	window.onresize = gwap.ParentWindowResize;
}